﻿/*
VERSION:		1.6

USAGE:
	XML.prototype.ignoreWhite = true;
	var myXml:XML = new XML();
	myXml.onLoad = function(success)
	{
		#include "readXml.as"
		readXml( myXml, _root );
	}
	myXml.load("sample.xml");
	
*/

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
// Value reading function
readXml_getValue = function( newValue )
{
	var output = null;
	// write as stored type  (if type is specified)
	var varType = newValue.substr(0,4);
	if( varType=="bol_" ){
		var theRest = newValue.substr(4);
		newValue = (theRest=="true");
		output = newValue;
	}else if( varType=="num_" ){
		var theRest = newValue.substr(4);
		newValue = Number(theRest);
		output = newValue;
	}else if( varType=="str_" ){
		var theRest = newValue.substr(4);
		newValue = String(theRest);
		output = newValue;
	}
	else
	{// if:  variable type is NOT specified
		// if it's a number, store is as one
		if ( isNaN( Number(newValue) )  )
		{// if:  not a number
			// check if it's actually a boolean value
			if ( newValue == "true"){
				output = true;
			}else if( newValue == "false"){
				output = false;
			}
			else
			{// if:  this is a string
				// // filter out redundant carriage returns (keyCode 10)
				var filteredString = "";
				var removeChar = String.fromCharCode(10);	// redundant carriage return	(normal ones are 13)
				var startAt=0;
				var endAt=0;
				while( endAt != undefined )
				{
					endAt = newValue.indexOf(removeChar, startAt);
					if(endAt == -1){ endAt=undefined }
					stringSlice = newValue.slice(startAt, endAt);
					startAt = endAt+1;
					filteredString += stringSlice;
				}// loop:  until endAt = undefined
				newValue = filteredString;
				// store
				output = newValue;
			}// if:  this is a string
		}// if:  not a number
		else
		{// if:  this is a number
			// store as a number
			output = Number(newValue);
		}// if:  this is a number
	}// if:  variable type is NOT specified
	return output;
}// getValue()



// END:	Value reading function
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
// XML Loading function
readXml = function( parentPath, targetData )
{
	// loop through attributes
	for ( var childName in parentPath.attributes)
	{
		// create a new variable
		// // Ignore "xmlType", since they're only used to help the parser.
		if (childName != "xmlType")
		{
			var newValue = parentPath.attributes[childName];
			targetData[childName] = readXml_getValue( newValue );
		}// END:  if (variable)
		delete childName;
	}// END:  for...in (parentPath.attributes)
	
	// loop through all the nodes
	for ( var childIndex in parentPath.childNodes)
	{
		var childPath:XMLNode = parentPath.childNodes[childIndex];
		var childName = childPath.nodeName;
		// read the type
		var childType:String = childPath.attributes.xmlType;
		// create variable according to type
		
		if (childType == "array" )
		{
			// create new array
			targetData[childName] = new Array();
			// read the elements for this new array
			var childData = targetData[childName];
			//showLoadedData();
			readXml( childPath, childData );
		}// END:  if (array)
		
		else	if (childType == "variable" )
		{
			// create a new variable
			var newValue = childPath.attributes.value;
			targetData[childName] = readXml_getValue( newValue );
		}// END:  if (variable)
		
		else if (childType == "object" )
		{
			// create a new object
			targetData[childName] = new Object();
			// read the elements for this new array
			var childData = targetData[childName];
			// read the variables of this new object
			readXml( childPath, childData );
		}// END:  if (object)

	}// END:  for...in (parentPath.childNodes)
	delete childIndex;
	delete stringSlice;
}
// END:	XML Loading function
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
